<%--
$Header: Product.jsp, 37, 5/1/01 3:46:28 PM, Schwartz, Joe$
$Log: 
 37   Alkindi Development1.36        5/1/01 3:46:28 PM    Schwartz, Joe   Added
      code to create appropriate url for the new backPageURL param for the
      movieProductPage template.
 36   Alkindi Development1.35        5/1/01 12:29:12 PM   Schwartz, Joe   Uses
      submitted average rating.
 35   Alkindi Development1.34        5/1/01 10:31:39 AM   Schwartz, Joe   Gets
      PR from database if not passed in HTTP request.
 34   Alkindi Development1.33        2/23/01 5:39:22 PM   Schwartz, Joe   Basic
      changes for new RecMgr interface, new Product id type (int) and
      Rating/Recommendation evaluation type (float).
 33   Alkindi Development1.32        1/19/01 12:41:43 PM  Schwartz, Joe  
      Changed to use new Refresh.inc page instead of refreshTag() function. Most
      pages now have an inactivity timeout.
 32   Alkindi Development1.31        1/18/01 4:05:06 PM   Schwartz, Joe  
      Changed String compareTo() to equals() where possible; renamed _SESSID
      constants to _SESSVAR.
 31   Alkindi Development1.30        1/16/01 6:12:20 PM   Schwartz, Joe  
      Replaced "Alkindi" graphic at top of main content (was removed for
      debugging).
 30   Alkindi Development1.29        1/16/01 12:18:55 PM  Schwartz, Joe  
      Modified to use new getAlkindexImage.
 29   Alkindi Development1.28        1/16/01 12:06:40 PM  Schwartz, Joe   Fixed
      alignment of top table.
 28   Alkindi Development1.27        1/16/01 11:23:56 AM  Schwartz, Joe  
      Resctricted average rating to 1 decimal place per CR 241.
 27   Alkindi Development1.26        1/15/01 4:03:32 PM   Schwartz, Joe   Uses
      refreshTag() function to get meta refresh tag.
 26   Alkindi Development1.25        1/15/01 12:59:33 PM  Schwartz, Joe   Added
      2-digit minimum to decimal part of average rating display.
 25   Alkindi Development1.24        1/12/01 6:37:32 PM   Schwartz, Joe   Added
      meta redirect tag to time out session after 1200 secs (20 min).
 24   Alkindi Development1.23        1/12/01 1:29:36 PM   Schwartz, Joe   Added
      number formatting for average rating display.
 23   Alkindi Development1.22        1/11/01 11:19:50 PM  Schwartz, Joe   Made
      space at top line up.
 22   Alkindi Development1.21        1/11/01 2:53:15 PM   Schwartz, Joe   Fixed
      various positioning issues.
 21   Alkindi Development1.20        1/11/01 1:38:09 PM   Schwartz, Joe   Worked
      on problem in which Prod Page heading was pushed too far to the right.
 20   Alkindi Development1.19        1/11/01 12:02:10 PM  Schwartz, Joe   Made
      sure all body tags set margins correctly for Netscape.
 19   Alkindi Development1.18        1/10/01 9:40:28 PM   Schwartz, Joe   Fixed
      problem with unreasonable width of content.
 18   Alkindi Development1.17        1/10/01 8:43:39 PM   Schwartz, Joe  
      Changed Alkindex image tooltip to match MyAlkindi.jsp.
 17   Alkindi Development1.16        1/10/01 7:55:20 PM   Schwartz, Joe  
      Activated "go" button under alkindex.
 16   Alkindi Development1.15        1/10/01 7:40:08 PM   Schwartz, Joe   Now
      uses new alkindexHeader style instead of dkblue2back. Added "key" row to
      header & adjusted positioning.
 15   Alkindi Development1.14        1/10/01 12:14:54 PM  Schwartz, Joe   Made
      more resize-friendly.
 14   Alkindi Development1.13        1/5/01 12:59:50 PM   Schwartz, Joe  
      Changed to use new Leftnav.inc. Added source control keywords.
 13   Alkindi Development1.12        12/29/00 5:57:52 PM  Schwartz, Joe  
      Chagned to reflect new double value for average rating member of
      Recommendation object.
 12   Alkindi Development1.11        12/11/00 4:37:51 PM  Schwartz, Joe  
      Changed references to HTTP LOCATION header to calls to response object
      sendRedirect() function.
 11   Alkindi Development1.10        12/11/00 4:34:24 PM  Schwartz, Joe  
      Removed references to showErrorPage() function.
 10   Alkindi Development1.9         12/11/00 3:45:43 PM  Schwartz, Joe   Added
      new erorr page to JSP header.
 9    Alkindi Development1.8         12/11/00 3:33:34 PM  Schwartz, Joe  
      Chagned to work with resin XSLT parser: values for top-level parmeters are
      no longer enclosed in single-quotes.
 8    Alkindi Development1.7         12/8/00 12:58:13 PM  Schwartz, Joe  
      Cleaned up spaces bewteen navigation table and page heading.
 7    Alkindi Development1.6         12/1/00 2:44:46 PM   Schwartz, Joe   
 6    Alkindi Development1.5         11/21/00 11:17:35 PM Schwartz, Joe   
 5    Alkindi Development1.4         11/20/00 10:51:14 PM Schwartz, Joe   
 4    Alkindi Development1.3         11/18/00 10:52:25 AM Schwartz, Joe   
 3    Alkindi Development1.2         11/14/00 5:49:39 PM  Schwartz, Joe   
 2    Alkindi Development1.1         11/14/00 12:51:10 PM Schwartz, Joe   
 1    Alkindi Development1.0         11/11/00 5:01:28 PM  Schwartz, Joe   
$
$NoKeywords$
--%><%@page language="java" buffer="64kb" errorPage="/Error.jsp"%>
<%@include file="Common.inc"%>
<%!
RatingList ratingList = null;
RecommendationList recList = null;
SystemUser su = null;
String screenName = "";
int productID;
float predRating=0f;
Recommendation rec;
%>
<%
//	Check for current user. One must exist or the 
//	user is redirected to the login page.
//
su = (SystemUser)session.getAttribute(USER_SESSVAR);
if (su == null) {
	response.sendRedirect(response.encodeRedirectUrl(START_PAGE));
}
	//	Retrieve screen Name
	//
	screenName = getAcctMgr().getScreenName(su);
	if (null == screenName) {
		screenName = "Guy Dude";
	}

	//	Retrieve the product ID
	//
	productID = 0;
	String prodStr = request.getParameter(PRODID_PARAM);
	if (prodStr == null) {
		throw new AlkExcept("No product specified for product page.", 8000);
	}
	try {
		productID = Integer.parseInt(prodStr);
	}
	catch (NumberFormatException nfe) {
		throw new AlkExcept("Bad product id specified: " + prodStr, 8000);
	}

	//	Create utility product object.
	//
	Product prod = new Product(productID);
	
	//	Create the Recommendation for the product.
	//
	rec = new Recommendation(su, prod, 0, 0);

	//	Get the submitted average rating, if any, and add to the Recommendation object.
	//
	try {
		rec.averageEval = Float.parseFloat(request.getParameter(AVGRATING_PARAM));
	}
	catch (Exception e) {
	}

	//	Check for submitted predicted rating. Modify Recommendation 
	//	if found; otherwise get the PR from the middleware.
	//	
	String predRatStr = request.getParameter(PREDRATING_PARAM);
	if (predRatStr != null) {
		try {
			predRating = Float.parseFloat(predRatStr);
			rec.evaluation = predRating;
		}
		catch (NumberFormatException nfe) {
			predRatStr = null;
//			throw new AlkExcept("Sent bad predicted rating to Product page.", 8000);
		}
		
	}
	if (predRatStr == null) {
		IRecommendationManagerBean rmb = getRecMgr();
		rec.evaluation = rmb.getPredictedRating(su, rec.prod);
	}
	
	//	Create the recommendation list.
	//
	recList = new RecommendationList();
	recList.add(rec);
	
	//	Attempt to handle submitted rating.
	//
	try {
		handlePostedRatings(request, null);
	}
	catch (Exception e) {
		ratingList = null;
	}
	//	TODO: If a rating list was retrieved, store the rating at session scope.
	//
	if (null != ratingList) {
	}
	else {
		//	Otherwise, create rating & rating list for the product
		//
		Rating rat = new Rating(su, prod, 0);
		ratingList = new RatingList();
		ratingList.add(rat);
	}
%><%=DOC_TYPE%>
<html>
<head>
<%@include file="Refresh.inc"%>
<%=releaseNum()%>
<title>Alkindi: <%=getMovieName(productID)%></title>
<link rel=stylesheet type="text/css" href="website.css"/>
<%@include file="CommonJS.inc"%>
<%@include file="Leftnav_script.inc"%>
<%@include file="RecMovies_script.inc"%>
</head>
<body id="stdbody" onLoad="onLoadPage();" marginwidth="0" marginheight="0" link="#ffffff" vlink="#ffffff" alink="#ffffff">
<%@include file="Header.inc"%>
<table width="776" cellpadding="0" cellspacing="0" border="0">
<tr>
	<%-- navigation panel --%>
	<td id="leftnavpane" valign="top" align="left">	<%@include file="Leftnav.inc"%></td>
	<%-- help info --%>
	<td valign="top" align="left">
		<table width="597" border="0" cellpadding="0" cellspacing="0">
		<tr align="left" id="greenback"> 
			<td align="left" valign="top" colspan="2" height="37"><img src="images/spacer.gif" width="18" height="37" alt="spacer"><img src="images/int_headerlogo.gif" width="85" height="25" vspace="4" alt="Alkindi"><img src="images/int_header_productpage.gif" height="21" vspace="4" hspace="4" alt="Alkindi Product Page"></td>
			<td width="126"id="greenback" rowspan="2" valign="top" align="right" width="126"><%=getAlkindexImage(su)%></td>
		</tr>
		<tr> 
			<td colspan="2" valign="top" height="34"> <%--Start Help Text Content Table --%> 
				<table width="469" border="0" cellspacing="0" cellpadding="2">
				<tr> 
				    <td valign="top" width="8"><img src="images/spacer.gif" width="8" height="32" alt="spacer"></td>
				    <td id="wtback" valign="top">
						<span id="normaltext">If you've seen the following movie, please rate it. If you'd like to save it for later, check the &quot;add to my list&quot; box above the picture and then hit the &quot;submit&quot; button at the bottom of the page.</span>
					</td>
				 </tr>
				</table><%--End Help Text Content Table--%> 
			</td>
		</tr>
		<tr> 
			<td id="ltblueback" width="217" valign="top" align="center" height="12"><img src="images/ratingbox_predicted.gif" width="131" height="14" vspace="4" alt="Predicted Rating"></td>
			<td id="medblue2back" width="254" valign="top" align="center" height="12"><img src="images/ratingbox_yours.gif" width="98" height="14" alt="Your Rating" vspace="4"></td>
			<td id="alkindexHeader" valign="top" width="126"><img src="images/improve_box_old.gif" width="84" height="26" align="top" hspace="5"><a href="<%=IMPROVE_ALKINDEX_PAGE%>"><img src="images/gobutton_navybak.gif" width="24" height="26" align="top" hspace="3" border="0"></a></td>
		</tr>
		<tr align="left">
			<td colspan="3" id="wtback" valign="top" align="left">
				<form name="<%=RATS_FORM_NAME%>" action="<%=request.getRequestURI()%>" method="get" >
					<%
						java.text.NumberFormat nf = java.text.NumberFormat.getInstance();
						nf.setMinimumFractionDigits(1);
						nf.setMaximumFractionDigits(1);
						Hashtable params = new Hashtable();
						params.put("movieArtRoot", "movie_art");
						params.put("aveRating", nf.format(rec.averageEval));
						params.put("addMyListParam", ADD_MYLIST_PARAM);
						
						//	Set up the URL to which the "previous page" button goes. 
						//	This is the Referrer page. [Note bad spelling of HTTP header.]
						//
						String backURL = request.getHeader("Referer");
						
						//	If the page was My Alkindi or Alkindi Recommends, 
						//	chop off the query string.
						//
						if ((backURL.indexOf(MY_ALKINDI_PAGE) > 0) || (backURL.indexOf(ALKINDI_RECS_PAGE) > 0)) {
							int queryPos = backURL.indexOf('?');
							if (queryPos > 1) 
								backURL = backURL.substring(0, queryPos);
						}
						params.put("backPageURL", backURL);
						
							
						out.println(paramProcessXmlWithXsl(getXmlMovieFile(productID), "xsl/movieProductPage.xsl", params));
					%>
					<input type="hidden" name="<%=PRODID_PARAM%>" value="<%=productID%>"/>
					<input type="hidden" name="<%=RATING_PARAM%>" value="0"/>
					<input type="hidden" name="<%=PREDRATING_PARAM%>" value="<%=predRating%>"/>
				</form>
			</td>
		</tr>
		<tr>
			<td colspan="3"><%@include file="Footer.inc"%></td>
		</tr>
		</table>
	</td>
</tr>
</table>
<%@include file="RecMovies_maps.inc"%>
<%@include file="Debug.inc"%>
</body>

</html><%
out.close();%>
